/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

// Further adapted by TheEmu by 
//   1) Replacing sets of x,y,z scalars by vectors
//   2) Minimising conditionaly executed code
//   3) Other minor tidyings

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize
#define iMouse AUTO_MOUSE

/////////////////////////////////////////////////////////////////////////////////

// Simple "Automatic Mouse". Simulates scanning the mouse over the full range of
// the screen with the X and Y scanning frequencies being different. TheEmu.

#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
#define MOUSE_POS   vec2((1.0+cos(iGlobalTime*MOUSE_SPEED))*u_WindowSize/2.0)
#define MOUSE_PRESS vec2(0.0,0.0)
#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )

/////////////////////////////////////////////////////////////////////////////////

#define time iGlobalTime*0.25
#define PI 3.14159265359

mat3 rot(vec3 ang)
{
	mat3 x = mat3(1.0,0.0,0.0,0.0,cos(ang.x),-sin(ang.x),0.0,sin(ang.x),cos(ang.x));
	mat3 y = mat3(cos(ang.y),0.0,sin(ang.y),0.0,1.0,0.0,-sin(ang.y),0.0,cos(ang.y));
	mat3 z = mat3(cos(ang.z),-sin(ang.z),0.0,sin(ang.z),cos(ang.z),0.0,0.0,0.0,1.0);
	return x*y*z;
}

float noise3D(vec3 p)
{
	return fract(sin(dot(p ,vec3(12.9898,78.233,126.7235))) * 43758.5453);
}

float worley3D(vec3 p)
{					 					 
	float r = 3.0;
    vec3 f = floor(p);
    vec3 x = fract(p);
	for(int i = -1; i<=1; i++)
	{
		for(int j = -1; j<=1; j++)
		{
			for(int k = -1; k<=1; k++)
			{
                vec3 q = vec3(float(i),float(j),float(k));
    			vec3 v = q + vec3(noise3D((q+f)*1.11), noise3D((q+f)*1.14), noise3D((q+f)*1.17)) - x;
    			float d = dot(v, v);
				r = min(r, d);
			}
		}
	}
    return sqrt(r);
}

void main( void )
{
    vec2 uv = gl_FragCoord.xy/iResolution.xy;
	vec2 p = uv*2.0-1.0;
	p.x*=(iResolution.x/iResolution.y);
	vec3 col = vec3(0.1,0.2,0.3);
    vec3 ro = vec3(0.0,0.0,-2.0);
    vec3 rd = normalize(vec3(p,0.0)-ro);
    float mx = iMouse.x > 0.0 ? iMouse.x/iResolution.x : 0.5;
    float my = iMouse.y > 0.0 ? iMouse.y/iResolution.y : 0.5;
    vec3 ang = vec3((my-0.5)*PI, (mx-0.5)*PI, 0.0);
    ro*=rot(ang);
    rd*=rot(ang);
    vec3 rp = ro;
    float t = 1.0;
    float w;
    float ww;
    vec3 add;
    for(int i = 0; i<12; i++)
   	{       
        rp+= rd*t;
        w = worley3D(rp+vec3(0.0,0.0,time));
        ww = w*w*w*w*w*(2.0/distance(rp,ro));
        add = vec3(0.85,0.95,1.0);
        col = mix(col, add, ww);
    }
    
    rp = ro + rd*(12.0*(time-floor(time))+0.5);
    w = worley3D(rp+vec3(0.0,0.0,time));
    ww = w*w*w*w*w*w*(4.0/distance(rp,ro));
    add = vec3(0.12,0.35,0.5);
    col = mix(col, add , ww);
    
    rp = ro + rd*(8.0);
    w = worley3D(rp+vec3(0.0,0.0,time));
    ww = w*w*w*w*w*w*(2.0/distance(rp,ro));
    add = vec3(1.0,0.65,0.0);
    col = mix(col, add , ww);
    
    rp = ro + rd*(12.0);
    w = worley3D(rp+vec3(0.0,0.0,time));
    ww = w*w*w*w*w*w*(2.0/distance(rp,ro));
    add = vec3(1.0,0.81,0.0);
    col = mix(col, add , ww);

	gl_FragColor = vec4(col*rot(ang*.05),1.0);
}